#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix0(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=0;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix1(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=1;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix10(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=10;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix11(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=11;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix12(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=12;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix13(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=13;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix14(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=14;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix15(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=15;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix17(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=17;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix2(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=2;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix3(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=3;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix4(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=4;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix5(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=5;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix6(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=6;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix7(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=7;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix8(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=8;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I32imm_I8fix9(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit32u arg0;
Bit8u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0=immdat;
arg1=9;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit32s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix0(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=0;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix1(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=1;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix10(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=10;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix11(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=11;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix12(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=12;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix13(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=13;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix14(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=14;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix15(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=15;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix16(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=16;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix17(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=17;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix2(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=2;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix3(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=3;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix4(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=4;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix5(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=5;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix6(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=6;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix7(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=7;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix8(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=8;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}

void BX_CPU_C::EXEC_jmp32_I8imm_I8fix9(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Boolean condition;
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);

arg0=immdat;
arg1=9;

switch (arg1) {
  case 0x00: /* JO */ condition = get_OF(); break;
  case 0x01: /* JNO */ condition = !get_OF(); break;
  case 0x02: /* JB */ condition = get_CF(); break;
  case 0x03: /* JNB */ condition = !get_CF(); break;
  case 0x04: /* JZ */ condition = get_ZF(); break;
  case 0x05: /* JNZ */ condition = !get_ZF(); break;
  case 0x06: /* JBE */ condition = get_CF() || get_ZF(); break;
  case 0x07: /* JNBE */ condition = !get_CF() && !get_ZF(); break;
  case 0x08: /* JS */ condition = get_SF(); break;
  case 0x09: /* JNS */ condition = !get_SF(); break;
  case 0x0A: /* JP */ condition = get_PF(); break;
  case 0x0B: /* JNP */ condition = !get_PF(); break;
  case 0x0C: /* JL */ condition = get_SF() != get_OF(); break;
  case 0x0D: /* JNL */ condition = get_SF() == get_OF(); break;
  case 0x0E: /* JLE */ condition = get_ZF() || (get_SF() != get_OF());
    break;
  case 0x0F: /* JNLE */ condition = (get_SF() == get_OF()) && !get_ZF();
    break;
  case 16: /* JECXZ */ condition = (ECX==0); break;
  default: condition = 1; break;
}
if (condition) {
  new_EIP = EIP + ((Bit8s)arg0);
#if BX_CPU_LEVEL >= 2
  if (protected_mode()) {
    if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
      //BX_PANIC(("jo_routine: offset outside of CS limits\n"));
      exception(BX_GP_EXCEPTION, 0, 0);
    }
  }
#endif
  EIP = new_EIP;
  BX_INSTR_CNEAR_BRANCH_TAKEN(new_EIP);
  revalidate_prefetch_q();
}
#if BX_INSTRUMENTATION
  else {
  BX_INSTR_CNEAR_BRANCH_NOT_TAKEN();
}
#endif
}
